<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : forms_validation                                             
#  RELEASE : "UK1.0.0.V01"                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:uk="http://enotice.service.gov.uk/resource/schema/UK/UK1.0.0/reception" exclude-result-prefixes="uk">
	<xsl:output method="xml" omit-xml-declaration="no" standalone="yes" indent="yes"/>
	<!--XML file name-->
	<xsl:param name="file">filename</xsl:param>
	<!--choice of message weight: PROD_WEGHT or QUAL_WEIGHT-->
	<xsl:param name="weight">PROD_WEIGHT</xsl:param>
	<xsl:include href="./build_message.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/">
		<VALIDATION_REPORT>
			<xsl:choose>
				<xsl:when test="not(uk:ukNotice)">
					<MESSAGE>Unknown file</MESSAGE>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</VALIDATION_REPORT>
	</xsl:template> 
	<xsl:template match="*:IDENTIFICATION">
		<IDENTIFICATION>
			<xsl:apply-templates/>
			<xsl:element name="FILE">
				<xsl:value-of select="$file"/>
			</xsl:element>
		</IDENTIFICATION>
	</xsl:template>
	<xsl:template match="*:ESENDER_LOGIN|*:CUSTOMER_LOGIN|*:NO_DOC_EXT">
		<xsl:choose>
			<xsl:when test="not(ancestor::*:SENDER)"/>
			<xsl:otherwise>
				<xsl:element name="{local-name()}">
					<xsl:value-of select="current()"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--to control only the first form in the case of bilinguale-->
	<xsl:template match="*:FORM_SECTION">
		<LOGS>
			<xsl:apply-templates select="." mode="R101"/>
			<xsl:apply-templates select="." mode="R102"/>
			<xsl:apply-templates select="." mode="R103"/>
			<xsl:apply-templates select="." mode="R104"/>
			<xsl:apply-templates select="." mode="R105"/>
			<xsl:apply-templates select="." mode="R106"/>
			<xsl:apply-templates select="." mode="R107"/>
			<xsl:apply-templates select="." mode="R108"/>
			<xsl:apply-templates select="." mode="R109"/>
			<xsl:apply-templates select="." mode="R110"/>
			<xsl:apply-templates select="." mode="R111"/>
			<xsl:apply-templates select="." mode="R112"/>
			<xsl:apply-templates select="." mode="R113"/>
			<xsl:apply-templates select="." mode="R114"/>
			<xsl:apply-templates select="." mode="R115"/>
			<xsl:apply-templates select="." mode="R116"/>
			<xsl:apply-templates select="." mode="R117"/>
		</LOGS>
	</xsl:template>
	<!---->
	<xsl:include href="./section0.xsl"/>
	<xsl:template match="text()" priority="-1" mode="#all"/>
	<xsl:template match="@*|node()" priority="-2" mode="#all">
		<xsl:apply-templates select="@*|*" mode="#current"/>
	</xsl:template>
</xsl:stylesheet>
