<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section0
#  RELEASE : "UK1.0.0.V01"                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="2.0" xmlns:mi="http://www.w3.org/2001/XMLSchema-instance" xmlns:uk="http://enotice.service.gov.uk/resource/schema/UK/UK1.0.0/reception" exclude-result-prefixes="uk">

	<!-- rule 101 procurement start date (tender.tenderPeriod.startDate) must be in the future -->
	<xsl:template match="*:FORM_SECTION" mode="R101">
		<xsl:variable name="tenderStartDate" select=".//*:tenderPeriod/*:startDate" />
		<xsl:if test="not(xs:dateTime($tenderStartDate) &gt;= xs:dateTime(current-dateTime()))">
			<xsl:variable name="currentDateTime" select="xs:dateTime(current-dateTime())" />
			<xsl:variable name="details" select="concat('tender/tenderPeriod/startDate: ', $tenderStartDate, ' Current Date Time: ', $currentDateTime)" />
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R101'" />
				<xsl:with-param name="content" select="$details" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- rule 102 Contract start date (tender/contractPeriod/startDate) must be after the procurement start date (tender/tenderPeriod/startDate) -->
	<xsl:template match="*:FORM_SECTION" mode="R102">
		<xsl:variable name="tenderContractStartDate" select=".//*:contractPeriod/*:startDate" />
		<xsl:variable name="tenderPeriodStartDate" select=".//*:tenderPeriod/*:startDate" />
		<xsl:if test="(xs:dateTime($tenderContractStartDate) &lt;= xs:dateTime($tenderPeriodStartDate))">
			<xsl:variable name="details" select="concat('tender/contractPeriod/startDate: ', $tenderContractStartDate, ', tender/tenderPeriod/startDate: ', $tenderPeriodStartDate)" />
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R102'" />
				<xsl:with-param name="content" select="$details" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- rule 103 (buyer.id) must exist in parties and have roles buyer -->
	<xsl:template match="*:FORM_SECTION" mode="R103">
		<xsl:variable name="buyerId" select=".//*:buyer/*:id" />
		<xsl:variable name="partiesId" select=".//*:parties[*:id=$buyerId]/*:id" />
		<xsl:variable name="roles">
			<xsl:for-each select=".//*:parties[*:id=$buyerId]/*:roles">
				<xsl:value-of select="concat(current(),';')" />
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains($roles,'buyer') and $buyerId != '' and $partiesId != '' and $partiesId = $buyerId" />
			<xsl:otherwise>
				<xsl:variable name="details" select="concat('buyer/id: ', $buyerId, ', parties/id: ', $partiesId, ', roles: ', $roles)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R103'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 104 countryCode and NUTS code must match -->
	<xsl:template match="*:FORM_SECTION" mode="R104">
		<xsl:for-each select=".//*:parties">
			<xsl:variable name="countryCode" select="./*:address/*:countryCode" />
			<xsl:variable name="region" select="./*:address/*:region" />
			<xsl:choose>
				<xsl:when test="('XK' = $countryCode) and starts-with($region,'1A')" />
				<xsl:when test="('GB' = $countryCode or 'GI' = $countryCode) and starts-with($region,'UK')" />
				<xsl:when test="('GR' = $countryCode) and starts-with($region,'EL')" />
				<xsl:when test="('GF' = $countryCode or 'GP' = $countryCode or 'MF' = $countryCode or 'MQ' = $countryCode or 'RE' = $countryCode or 'YT' = $countryCode) and starts-with($region,'FR')" />
				<xsl:when test="'AX' = $countryCode and starts-with($region,'FI')" />
				<xsl:when test="starts-with($region, $countryCode)" />
				<xsl:otherwise>
					<xsl:variable name="details" select="concat('address/countryCode: ', $countryCode, ', address/region: ', $region)" />
					<xsl:call-template name="msg">
						<xsl:with-param name="rule" select="'R104'" />
						<xsl:with-param name="content" select="$details" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<!-- rule 105 If relatedProcesses/relationship includes "prior", relatedProcesses/documents must be present with id "notice" -->
	<xsl:template match="*:FORM_SECTION" mode="R105">
		<xsl:for-each select=".//*:relatedProcesses">
			<xsl:variable name="document_ids">
				<xsl:for-each select="./*:documents">
					<xsl:value-of select="concat(current()/*:id,';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="relatedProcessesRelationship">
				<xsl:for-each select="./*:relationship">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="contains($relatedProcessesRelationship,'prior')">
				<xsl:choose>
					<xsl:when test="contains($document_ids,'notice')" />
					<xsl:otherwise>
						<xsl:variable name="details" select="concat('relatedProcesses/relationship: ', relatedProcessesRelationship, ',documents/id: ', $document_ids)" />
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R105'" />
							<xsl:with-param name="content" select="$details" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!-- rule 106 If relatedProcesses/relationship is "framework" , relatedProcesses/parties/roles must include "procuringEntity" -->
	<xsl:template match="*:FORM_SECTION" mode="R106">
		<xsl:for-each select=".//*:relatedProcesses">
			<xsl:variable name="relatedProcessesRelationship">
				<xsl:for-each select="./*:relationship">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="roles">
				<xsl:for-each select=".//*:parties/*:roles">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="contains($relatedProcessesRelationship,'framework')">
				<xsl:choose>
					<xsl:when test="contains($roles,'procuringEntity')" />
					<xsl:otherwise>
						<xsl:variable name="details" select="concat('relatedProcesses/relationship: ', $relatedProcessesRelationship, ', parties/roles: ', $roles)" />
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R106'" />
							<xsl:with-param name="content" select="$details" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!-- rule 107 If relatedProcesses/relationship includes "framework", relatedProcesses/parties/roles must not include "supplier" and relatedProcesses/tender/contractPeriod/endDate must not be present -->
	<xsl:template match="*:FORM_SECTION" mode="R107">
		<xsl:for-each select=".//*:relatedProcesses">
			<xsl:variable name="relatedProcessesRelationship">
				<xsl:for-each select="./*:relationship">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="roles">
				<xsl:for-each select=".//*:parties/*:roles">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="contains($relatedProcessesRelationship,'framework')">
				<xsl:variable name="contractPeriodEndDate" select="./*:tender/*:contractPeriod/*:endDate" />
				<xsl:choose>
					<xsl:when test="not(contains($roles,'supplier')) and not($contractPeriodEndDate)" />
					<xsl:otherwise>
						<xsl:variable name="details" select="concat('relatedProcesses/relationship: ', $relatedProcessesRelationship, ', parties/roles: ', $roles, ', relatedProcesses/tender/contractPeriod/endDate: ',$contractPeriodEndDate)" />
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R107'" />
							<xsl:with-param name="content" select="$details" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!-- rule 108 If relatedProcesses/relationship includes "prior", relatedProcesses/parties/roles must not include "procuringEntity", relatedProcesses/documents/id must not be "procuringEntity", and relatedProcesses/lot must not be present -->
	<xsl:template match="*:FORM_SECTION" mode="R108">
		<xsl:for-each select=".//*:relatedProcesses">
			<xsl:variable name="relatedProcessesRelationship">
				<xsl:for-each select="./*:relationship">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="document_ids">
				<xsl:for-each select="./*:documents">
					<xsl:value-of select="concat(current()/*:id,';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="roles">
				<xsl:for-each select=".//*:parties/*:roles">
					<xsl:value-of select="concat(current(),';')" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="contains($relatedProcessesRelationship,'prior')">
				<xsl:choose>
					<xsl:when test="not(contains($roles,'procuringEntity')) and not(contains($document_ids,'procuringEntity')) and not(./*:lot)" />
					<xsl:otherwise>
						<xsl:variable name="details" select="concat('relatedProcesses/relationship: ', $relatedProcessesRelationship, ', documents/id: ', $document_ids, ', parties/roles: ', $roles)" />
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R108'" />
							<xsl:with-param name="content" select="$details" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!-- rule 109 Main CPV code (tender.classification) must align with contract type (tender.mainProcurementCategory) - Supplies 0 to 44, 48, Works 45, Services 49 to 98 -->
	<xsl:template match="*:FORM_SECTION" mode="R109">
		<xsl:variable name="tenderClassificationFull" select=".//*:tender/*:classification/*:id" />
		<xsl:variable name="tenderMainProcurementCategory" select=".//*:tender/*:mainProcurementCategory" />
		<xsl:variable name="tenderClassification">
			<xsl:value-of select="substring($tenderClassificationFull,1,2)" />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="($tenderClassification &lt;= 44 or $tenderClassification = 48) and $tenderMainProcurementCategory = 'goods'" />
			<xsl:when test="$tenderClassification = 45 and $tenderMainProcurementCategory = 'works'" />
			<xsl:when test="$tenderClassification &gt;= 49 and $tenderClassification &lt;= 98 and $tenderMainProcurementCategory = 'services'" />
			<xsl:otherwise>
				<xsl:variable name="details" select="concat('tender/classification/id: ', $tenderClassificationFull, ', tender/mainProcurementCategory: ', $tenderMainProcurementCategory)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R109'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 110 Either both tender.hasOptions and tender.options must be present or neither -->
	<xsl:template match="*:FORM_SECTION" mode="R110">
		<xsl:variable name="tenderHasOptions" select=".//*:tender/*:hasOptions" />
		<xsl:choose>
			<xsl:when test=".//*:tender/*:hasOptions and .//*:tender/*:options and $tenderHasOptions = 'true'" />
			<xsl:when test="(not(.//*:tender/*:hasOptions) or $tenderHasOptions = 'false') and not(.//*:tender/*:options)" />
			<xsl:otherwise>
				<xsl:variable name="details" select="'missing tender/hasOptions or tender/options'" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R110'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 111 tender.procurementMethod must match tender.procurementMethodDetails -->
	<xsl:template match="*:FORM_SECTION" mode="R111">
		<xsl:variable name="tenderProcurementMethod" select=".//*:tender/*:procurementMethod" />
		<xsl:variable name="tenderProcurementMethodDetails" select=".//*:tender/*:procurementMethodDetails" />
		<xsl:choose>
			<xsl:when test="not($tenderProcurementMethod) and not($tenderProcurementMethodDetails)" />
			<xsl:when test="$tenderProcurementMethod = 'open' and $tenderProcurementMethodDetails = 'Open procedure'" />
			<xsl:when test="$tenderProcurementMethod = 'limited' and $tenderProcurementMethodDetails = 'Call-off from a framework agreement'" />
			<xsl:when test="$tenderProcurementMethod = 'limited' and $tenderProcurementMethodDetails = 'Call-off from a dynamic purchasing agreement'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Restricted procedure'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Competitive procedure with negotiation'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Competitive dialogue'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Innovation partnership'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Procedure involving negotiations'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Negotiated procedure with prior call for competition'" />
			<xsl:when test="$tenderProcurementMethod = 'selective' and $tenderProcurementMethodDetails = 'Negotiated'" />
			<xsl:otherwise>
				<xsl:variable name="details" select="concat('tender/procurementMethod: ', $tenderProcurementMethod, ', tender/procurementMethodDetails: ', $tenderProcurementMethodDetails)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R111'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 112 The following fields are required for the main buyer: parties/address/streetAddress or parties/address/postalCode or parties/details/url -->
	<xsl:template match="*:FORM_SECTION" mode="R112">
		<xsl:variable name="buyerId" select=".//*:buyer/*:id" />
		<xsl:choose>
			<xsl:when test=".//*:parties[*:id=$buyerId]/*:address/*:streetAddress and .//*:parties[*:id=$buyerId]/*:address/*:postalCode and .//*:parties[*:id=$buyerId]/*:details/*:url" />
			<xsl:otherwise>
				<xsl:variable name="details" select="concat('parties/address/streetAddress: ', .//*:parties[*:id=$buyerId]/*:address/*:streetAddress, ', parties/address/postalCode: ', .//*:parties[*:id=$buyerId]/*:address/*:postalCode, ', parties/details/url: ', .//*:parties[*:id=$buyerId]/*:details/*:url)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R112'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 110 Either both tender.hasRenewal and tender.renewal must be present or neither -->
	<xsl:template match="*:FORM_SECTION" mode="R113">
		<xsl:variable name="tenderHasRenewal" select=".//*:tender/*:hasRenewal" />
		<xsl:choose>
			<xsl:when test=".//*:tender/*:hasRenewal and .//*:tender/*:renewal and $tenderHasRenewal = 'true'" />
			<xsl:when test="(not(.//*:tender/*:hasRenewal) or $tenderHasRenewal = 'false') and not(.//*:tender/*:renewal)" />
			<xsl:otherwise>
				<xsl:variable name="details" select="'missing tender/hasRenewal or tender/renewal'" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R113'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 114 (planning.budget.finance.financingParty.id) must exist in parties and have roles funder -->
	<xsl:template match="*:FORM_SECTION" mode="R114">
		<xsl:variable name="funderId" select=".//*:planning/*:budget/*:finance/*:financingParty/*:id" />
		<xsl:variable name="partiesId" select=".//*:parties[*:id=$funderId]/*:id" />
		<xsl:variable name="roles">
			<xsl:for-each select=".//*:parties[*:id=$funderId]/*:roles">
				<xsl:value-of select="concat(current(),';')" />
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="not($funderId)" />
			<xsl:when test="contains($roles,'funder') and $funderId != '' and $partiesId != '' and $partiesId = $funderId" />
			<xsl:otherwise>
				<xsl:variable name="details" select="concat('funder/id: ', $funderId, ', parties/id: ', $partiesId, ', roles: ', $roles)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R114'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 115 Procedure type (tender/procurementMethodDetails) must be valid under the selected regulations (UK1_2022/@LEGAL_BASIS).-->
	<xsl:template match="*:FORM_SECTION" mode="R115">
		<xsl:variable name="tenderProcurementMethodDetails" select=".//*:tender/*:procurementMethodDetails" />
		<xsl:variable name="legalBasis" select=".//@LEGAL_BASIS" />
		<xsl:choose>
			<xsl:when test="not($tenderProcurementMethodDetails)"/>

			<xsl:when test="contains($tenderProcurementMethodDetails,'Open procedure') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a framework agreement') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a dynamic purchasing agreement') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Restricted procedure') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Competitive procedure with negotiation') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Competitive dialogue') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Innovation partnership') and $legalBasis = '32014L0024'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Procedure involving negotiations') and $legalBasis = '32014L0024'"/>

			<xsl:when test="contains($tenderProcurementMethodDetails,'Open procedure') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a framework agreement') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a dynamic purchasing agreement') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Restricted procedure') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Competitive dialogue') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Innovation partnership') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Negotiated procedure with prior call for competition') and $legalBasis = '32014L0025'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Procedure involving negotiations') and $legalBasis = '32014L0025'"/>

			<xsl:when test="contains($tenderProcurementMethodDetails,'Open procedure') and $legalBasis = '32009L0081'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a framework agreement') and $legalBasis = '32009L0081'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Call-off from a dynamic purchasing agreement') and $legalBasis = '32009L0081'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Restricted procedure') and $legalBasis = '32009L0081'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Competitive dialogue') and $legalBasis = '32009L0081'"/>
			<xsl:when test="contains($tenderProcurementMethodDetails,'Negotiated') and $legalBasis = '32009L0081'"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('tender/procurementMethodDetails: ', $tenderProcurementMethodDetails , ' and [@FORM]LEGAL_BASIS: ',  $legalBasis)">
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R115'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rule 116 Contract end date (tender/contractPeriod/endDate) must be the same as or after the contract start date (tender/contractPeriod/startDate) -->
	<xsl:template match="*:FORM_SECTION" mode="R116">
		<xsl:variable name="tenderContractStartDate" select="./*/*:tender/*:contractPeriod/*:startDate" />
		<xsl:variable name="tenderContractEndDate" select="./*/*:tender/*:contractPeriod/*:endDate" />
			<xsl:if test="(xs:dateTime($tenderContractEndDate) &lt; xs:dateTime($tenderContractStartDate))">
				<xsl:variable name="details" select="concat('tender/contractPeriod/startDate: ', $tenderContractStartDate, ' tender/contractPeriod/endDate: ', $tenderContractEndDate)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R116'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:if>
	</xsl:template>
	
	<!-- rule 117 Additional CPV codes (tender/additionalClassification[scheme="CPV"]/id) must not include the main CPV(tender/classification/id) -->
	<xsl:template match="*:FORM_SECTION" mode="R117">
		<xsl:variable name="mainClassification" select="./*/*:tender/*:classification/*:id" />
		<xsl:for-each select="./*/*:tender/*:additionalClassifications">
			<xsl:variable name="scheme" select="./*/*:scheme" />
			<xsl:variable name="additionalClassification" select="./*:id" />
			<xsl:if test="$additionalClassification = $mainClassification ">
				<xsl:variable name="details" select="concat('tender/classification/id: ', $mainClassification, ' tender/additionalClassifications/id: ', $additionalClassification)" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R117'" />
					<xsl:with-param name="content" select="$details" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
