<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : build_message
#  RELEASE : "UK1.0.0.V01"                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<xsl:variable name="rules" select="document('./validation_rule.xml')"/>
	<xsl:template name="msg">
		<xsl:param name="rule"/>
		<xsl:param name="content"/>
		<xsl:if test="$rules//*[@RULE=$rule]">
		   <xsl:element name="LOG">
			 <xsl:element name="NAME">
			   <xsl:value-of select="$rule"/>
			 </xsl:element>
			 <xsl:element name="SEVERITY">
			   <xsl:value-of select="$rules//*[@RULE=$rule]/@*[local-name()=$weight]"/>
			 </xsl:element>
			 <xsl:element name="MESSAGE">
			   <xsl:value-of select="$rules//*[@RULE=$rule]"/>
			 </xsl:element>
			 <xsl:element name="DETAILS">
			   <xsl:value-of select="$content"/>
			 </xsl:element>
		   </xsl:element>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
