<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section4
#  Version : R2.0.8.UK1                                   
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/UK/R2.0.8/reception">
	<!-- Pattern ProcedureType -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15' or @FORM='18']| *[@FORM='4'][.//ANNEX_I]" mode="R178">
		<xsl:choose>
			<xsl:when test=".[@FORM='3']//TYPE_OF_PROCEDURE_DEF/*" />
			<xsl:when test=".[@FORM='4']//ANNEX_I//F04_TYPE_PROCEDURE/@TYPE" />
			<xsl:when test=".[@FORM='6']//TYPE_PROCEDURE_AWARD/*" />
			<xsl:when test=".[@FORM='15']//TYPE_OF_PROCEDURE_DEF_F15/*" />
			<xsl:when test=".[@FORM='18']//TYPE_OF_PROCEDURE_CONTRACT_AWARD_DEFENCE/*" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='3' or @FORM='6'">PT_OPEN|PT_RESTRICTED...</xsl:when>
						<xsl:when test="@FORM='4'">(ANNEX_I) F04_TYPE_PROCEDURE</xsl:when>
						<xsl:when test="@FORM='15'">F15_PT_NEGOTIATED_WITHOUT_COMPETITION|F15_AWARD_WITHOUT_PRIOR_PUBLICATION</xsl:when>
						<xsl:when test="@FORM='18'">PT_RESTRICTED|PT_ACCELERATED_RESTRICTED...</xsl:when>
					</xsl:choose>
					missing
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R178'" />
					<xsl:with-param name="content" select="$ele" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R178" />
	<xsl:template match="@*|node()" priority="-2" mode="R178">
		<xsl:apply-templates select="@*|*" mode="R178" />
	</xsl:template>
	<xsl:template match="*[@FORM='17' or @FORM='18' or @FORM='19'][.//*[matches(local-name(),'^PREVIOUS_PUBLICATION_EXISTS')][not(.//NOTICE_NUMBER_OJ)]]" mode="R197">
		<xsl:variable name="ele">
			<xsl:value-of select="concat(local-name(.//*[matches(local-name(),'^PREVIOUS_PUBLICATION_EXISTS')]),' - NOTICE_NUMBER_OJ missing')"/>
		</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R197'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R197"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R197"/>
	<xsl:template match="@*|node()" priority="-2" mode="R197">
		<xsl:apply-templates select="@*|*" mode="R197"/>
	</xsl:template>
	<!-- Pattern -->
	<!--<xsl:template match="*[@FORM='2'or @FORM='5' or @FORM='10' or @FORM='11' or @FORM='12'] | *[@FORM='4']//ANNEX_I" mode="R209">
		<xsl:choose>
			<xsl:when test=".//LANGUAGE_ANY_EC[@*='YES']|.//LANGUAGE_EC|.//LANGUAGE_OTHER[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">(ANNEX_I) </xsl:if>LANGUAGE_ANY_EC/LANGUAGE_EC/LANGUAGE_OTHER empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R209'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R209"/>
	</xsl:template>-->
	<xsl:template match="*[@FORM='17' or @FORM='19'][not(.//LANGUAGE) or .//LANGUAGE_ANY_EC/@*='NO']" mode="R209">
		<xsl:choose>
			<xsl:when test=".//LANGUAGE_OTHER[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="not(.//LANGUAGE)">LANGUAGE missing</xsl:if>
					<xsl:if test=".//LANGUAGE_ANY_EC/@*='NO'">LANGUAGE_ANY_EC/@*='NO' and LANGUAGE_OTHER empty/missing</xsl:if>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R209'" />
					<xsl:with-param name="content" select="$ele" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R209" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R209" />
	<xsl:template match="@*|node()" priority="-2" mode="R209">
		<xsl:apply-templates select="@*|*" mode="R209" />
	</xsl:template>
	<!---->
	<xsl:template match="RECEIPT_LIMIT_DATE|DATE_LIMIT_RECEIPT_INTEREST|DATE_LIMIT_RECEIPT_APPLICATION|TIME_LIMIT_CHP|F11_TIME_LIMIT_TYPE" mode="R557">
		<xsl:if test=".//YEAR[not(matches(normalize-space(text()),'^20'))]">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R557'" />
				<xsl:with-param name="content" select="concat(local-name(.),'//YEAR=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R557" />
	<xsl:template match="@*|node()" priority="-2" mode="R557">
		<xsl:apply-templates select="@*|*" mode="R557" />
	</xsl:template>
</xsl:stylesheet>
