<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section5
#  Version : R2.0.9.UK1                                        
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://publications.europa.eu/resource/schema/ted/R2.0.9/reception" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22'][.//*:NOTICE/@*!='AWARD_CONTRACT' and .//*:AWARD_CONTRACT]" mode="R600">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//*:NOTICE/@*,' and AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R600'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][.//*:NOTICE/@*!='CONCESSION_AWARD_CONTRACT' and .//*:AWARD_CONTRACT]" mode="R601">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//*:NOTICE/@*,' and AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R601'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22' or @FORM='F23'][.//*:NOTICE/@*[matches(.,'AWARD')] and not(.//*:AWARD_CONTRACT)]" mode="R608">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//*:NOTICE/@*,' and missing AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R608'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*:DATE_CONCLUSION_CONTRACT" mode="R602">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[matches(.,'CALL|QSU|ONLY|^CONTRACT|PRI')]"/>
			<xsl:when test="not(number(replace(text(),'-','')) &gt; number(replace(ancestor::*[@FORM]//*:DATE_DISPATCH_NOTICE/text(),'-','')))"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::*:AWARD_CONTRACT/@ITEM,']//DATE_CONCLUSION_CONTRACT=',.,',DATE_DISPATCH_NOTICE=',ancestor::*[@FORM]//*:DATE_DISPATCH_NOTICE)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R602'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//*:LEGAL_BASIS/@*!='32009L0081']//AWARDED_SUBCONTRACTING" mode="R604">
		<xsl:variable name="ele" select="concat('LEGAL_BASIS/@VALUE=', .//*:LEGAL_BASIS/@*,' and AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/AWARDED_SUBCONTRACTING')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R604'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//*:LEGAL_BASIS/@*!='32009L0081']//PCT_RANGE_SHARE_SUBCONTRACTING" mode="R605">
		<xsl:variable name="ele" select="concat('LEGAL_BASIS/@VALUE=', .//*:LEGAL_BASIS/@*,' and AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/PCT_RANGE_SHARE_SUBCONTRACTING')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R605'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//*:LEGAL_BASIS/@*='32009L0081']//PCT_RANGE_SHARE_SUBCONTRACTING/MAX[number()>30]" mode="R606">
		<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/PCT_RANGE_SHARE_SUBCONTRACTING/MAX (value=',number() ,'%)')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R606'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F13'][number(replace(.//*:DATE_DECISION_JURY/text(),'-','')) &gt;= number(replace(.//*:DATE_DISPATCH_NOTICE/text(),'-',''))]" mode="R607">
		<xsl:variable name="ele" select="concat('DATE_DECISION_JURY=',.//*:DATE_DECISION_JURY/text(),', DATE_DISPATCH_NOTICE=',.//*:DATE_DISPATCH_NOTICE/text())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R607'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM!='F20'][not(.//*:LOT_DIVISION)]//*:AWARD_CONTRACT[.//*:LOT_NO]" mode="R603">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,']/LOT_NO: ')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R603'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM!='F20'][.//*:LOT_DIVISION]//*:AWARD_CONTRACT//*:LOT_NO" mode="R609">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="count(ancestor::*[@FORM]//*:OBJECT_CONTRACT)>1"/>
			<xsl:when test="ancestor::*[@FORM]//*:OBJECT_DESCR[not(*:LOT_NO)]"/>
			<xsl:when test="normalize-space() = ancestor::*[@FORM]//*:OBJECT_DESCR/*:LOT_NO/normalize-space()"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::*/@ITEM,']/LOT_NO')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R609'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][not(.//*:FRAMEWORK or .//*:DPS or .//*:PT_INNOVATION_PARTNERSHIP)][.//*:AWARD_CONTRACT]" mode="R610R611">
		<xsl:choose>
			<xsl:when test="@FORM='F20'"/>
			<xsl:when test=".//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="(@FORM='F06' or @FORM='F22') and .//*:NOTICE_NUMBER_OJ"/>
			<xsl:when test="count(.//*:AWARD_CONTRACT)=1"/>
			<xsl:when test="count(.//*:AWARD_CONTRACT)=count(distinct-values(.//*:AWARD_CONTRACT/*:LOT_NO/normalize-space()))"/>
			<xsl:when test="(@FORM='F06' or @FORM='F22')">
				<xsl:variable name="ele" select="'AWARD_CONTRACT'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R611'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'AWARD_CONTRACT'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R610'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[.//*:TENDERS]" mode="R612">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:otherwise>
				<xsl:variable name="node" select="."/>
				<xsl:variable name="eles" select="'NB_TENDERS_RECEIVED_SME,NB_TENDERS_RECEIVED_OTHER_EU,NB_TENDERS_RECEIVED_NON_EU,NB_TENDERS_RECEIVED_EMEANS'"/>
				<xsl:for-each select="tokenize($eles, ',')">
					<xsl:variable name="ele" select="normalize-space(.)"/>
					<xsl:if test="not ($node//*[matches(local-name(),$ele)])">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R612'"/>
							<xsl:with-param name="content" select="concat('AWARD_CONTRACT[',$node/@ITEM,']//TENDERS[ missing ',$ele,']')"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[.//*:NB_TENDERS_RECEIVED]" mode="R613">
		<xsl:variable name="nb1" select="number(.//*:NB_TENDERS_RECEIVED_SME)"/>
		<xsl:variable name="nb2" select="sum((.//*:NB_TENDERS_RECEIVED_OTHER_EU, .//*:NB_TENDERS_RECEIVED_NON_EU))"/>
		<xsl:variable name="nb3" select="number(.//*:NB_TENDERS_RECEIVED_EMEANS)"/>
		<xsl:variable name="nb" select="max(
		(translate(string($nb1),'aN','0'),
		translate(string($nb2),'aN','0'),
		translate(string($nb3),'aN','0'))
		)"/>
		<xsl:variable name="nb_decl" select=".//*:NB_TENDERS_RECEIVED"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="number($nb_decl)>=number($nb)"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,'][.//NB_TENDERS_RECEIVED=',$nb_decl,
				', .//NB_TENDERS_RECEIVED_SME=',$nb1,
				', .//NB_TENDERS_RECEIVED_EMEANS=',$nb3,
				', sum(.//NB_TENDERS_RECEIVED_OTHER_EU, .//NB_TENDERS_RECEIVED_NON_EU)=',$nb2)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R613'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[number(.//*:NB_TENDERS_RECEIVED_SME)=0 and .//*:SME]" mode="R614">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test=".//*:NO_SME or .//*:CONTRACTOR[not(.//*:SME|.//*:NO_SME)]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,'][.//NB_TENDERS_RECEIVED_SME=0, .//SME]')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R614'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[number(.//*:NB_TENDERS_RECEIVED_OTHER_EU)=0]" mode="R615">
		<xsl:variable name="contract_body_cy">
			<xsl:for-each select="distinct-values( ancestor::*[@FORM]//*[matches(local-name(),'ADDRESS_CONTRACTING_BODY')]//*:COUNTRY/@*)">
				<xsl:value-of select="normalize-space(.)"/>
				<xsl:value-of select="' '"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test=".//*:COUNTRY/@*[not(matches(.,'AT|BE|BG|CY|CZ|DE|DK|EE|ES|FI|FR|UK|GR|HU|IE|IT|LT|LU|LV|MT|NL|PL|PT|RO|SE|SI|SK|HR'))]"/>
			<xsl:when test=".//*:COUNTRY/@*[contains($contract_body_cy,.)]"/>
			<xsl:otherwise>
				<xsl:variable name="contractor_cy">
					<xsl:for-each select="distinct-values( .//*:COUNTRY/@*)">
						<xsl:value-of select="normalize-space(.)"/>
						<xsl:value-of select="' '"/>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,'][.//NB_TENDERS_RECEIVED_OTHER_EU=0, .//ADDRESS_CONTRACTING_BODY(_ADDITIONAL)//COUNTRY/@*={ ', $contract_body_cy,'}, .//CONTRACTORS//COUNTRY/@*={ ', $contractor_cy,'}]')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R615'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[number(.//*:NB_TENDERS_RECEIVED_NON_EU)=0]" mode="R616">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test=".//*:COUNTRY/@*[matches(.,'AT|BE|BG|CY|CZ|DE|DK|EE|ES|FI|FR|UK|GR|HU|IE|IT|LT|LU|LV|MT|NL|PL|PT|RO|SE|SI|SK|HR')]"/>
			<xsl:otherwise>
				<xsl:variable name="contractor_cy">
					<xsl:for-each select="distinct-values( .//*:COUNTRY/@*)">
						<xsl:value-of select="normalize-space(.)"/>
						<xsl:value-of select="' '"/>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,'][.//NB_TENDERS_RECEIVED_NON_EU=0 and .//CONTRACTORS//COUNTRY/@*={ ', $contractor_cy,'}]')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R616'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]//*:AWARD_CONTRACT[number(.//*:NB_TENDERS_RECEIVED_SME)=number(.//*:NB_TENDERS_RECEIVED) and .//*:NO_SME]" mode="R617">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,'][.//NB_TENDERS_RECEIVED=',number(.//*:NB_TENDERS_RECEIVED) ,', .//NB_TENDERS_RECEIVED_SME=',number(.//*:NB_TENDERS_RECEIVED_SME),', .//NO_SME]')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R617'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F03']//*:AWARD_CONTRACT[.//*:AWARDED_CONTRACT and not(.//*:DATE_CONCLUSION_CONTRACT)]" mode="R618">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM][(.//*:LEGAL_BASIS/@*='32018R1046' or .//*:LEGAL_BASIS/@*='32012R0966' ) and .//*:PT_AWARD_CONTRACT_WITHOUT_CALL]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('LEGAL_BASIS/@VALUE=', ancestor::*[@FORM]//*:LEGAL_BASIS/@*,', ',local-name(ancestor::*[@FORM]//*:PROCEDURE/*[matches(local-name(),'^PT_')]), ', AWARD_CONTRACT[',@ITEM,'][.//DATE_CONCLUSION_CONTRACT missing]')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R618'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*:AWARD_CONTRACT[.//*:VAL_TOTAL]" mode="R619">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//*:OBJECT_CONTRACT[1]//*:VAL_TOTAL)"/>
			<xsl:when test="ancestor::*[@FORM]//*:OBJECT_CONTRACT[1]//*:VAL_TOTAL/@CURRENCY!=.//*:VAL_TOTAL/@CURRENCY"/>
			<xsl:when test="ancestor::*[@FORM]//*:OBJECT_CONTRACT[1]//*:VAL_TOTAL/number()>=.//*:VAL_TOTAL/number()"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[1][VAL_TOTAL = ',	
				ancestor::*[@FORM]//*:OBJECT_CONTRACT[1]//*:VAL_TOTAL/text(),' ',
				ancestor::*[@FORM]//*:OBJECT_CONTRACT[1]//*:VAL_TOTAL/@CURRENCY,
				'] and AWARD_CONTRACT[',./@ITEM,'][VAL_TOTAL = ',
				.//*:VAL_TOTAL/text(),' ',
				.//*:VAL_TOTAL/@CURRENCY,']')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R619'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*:PROCUREMENT_DISCONTINUED[not(*)]" mode="R620">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]/*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="not(ancestor::*[@FORM]//*:PROCEDURE/*[matches(local-name(),'^PT_')])"/>
			<xsl:when test="ancestor::*[@FORM]//*:PROCEDURE/*[matches(local-name(),'^PT_.*WITHOUT_')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="ancestor::*[@FORM='F13']">
						<xsl:value-of select="concat('PROCUREMENT_DISCONTINUED empty, ', local-name(.//ancestor::*[@FORM]//*[matches(local-name(),'^PT_')]))"/>
					</xsl:if>
					<xsl:if test="ancestor::*[@FORM!='F13']">
						<xsl:value-of select="concat('AWARD_CONTRACT[',.//ancestor::*:AWARD_CONTRACT/@ITEM,']//PROCUREMENT_DISCONTINUED empty, ',local-name(.//ancestor::*[@FORM]//*[matches(local-name(),'^PT_')]))"/>
					</xsl:if>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R620'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*:PROCUREMENT_DISCONTINUED[*]" mode="R621">
		<xsl:choose>
		<xsl:when test="ancestor::*[@FORM]/*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="not(ancestor::*[@FORM]//*:PROCEDURE/*[matches(local-name(),'^PT_')])"/>
			<xsl:when test="not(ancestor::*[@FORM]//*:PROCEDURE/*[matches(local-name(),'^PT_.*WITHOUT_')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',.//ancestor::*:AWARD_CONTRACT/@ITEM,']//PROCUREMENT_DISCONTINUED/* and ',
				local-name(ancestor::*[@FORM]//*[matches(local-name(),'^PT_')]))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R621'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
