<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section5
#  Version : R2.0.8.UK1                                        
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/UK/R2.0.8/reception">
	<!-- -->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(CONTRACT_AWARD_DATE)]|*[@FORM='3']//AWARD_OF_CONTRACT[not(CONTRACT_AWARD_DATE)] | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE[not(DATE_OF_CONTRACT_AWARD)] | *[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R215">
		<xsl:variable name="ele">
			<xsl:choose>
				<xsl:when test="ancestor::*/@FORM='3'">AWARD_OF_CONTRACT/CONTRACT_AWARD_DATE</xsl:when>
				<xsl:when test="ancestor::*/@FORM='18'">
					AWARD_OF_CONTRACT_DEFENCE[
					<xsl:value-of select="@ITEM" />
					]/CONTRACT_AWARD_DATE
				</xsl:when>
				<xsl:otherwise>DATE_OF_CONTRACT_AWARD</xsl:otherwise>
			</xsl:choose>
			missing
		</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R215'" />
			<xsl:with-param name="content" select="$ele" />
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R215" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R215" />
	<xsl:template match="@*|node()" priority="-2" mode="R215">
		<xsl:apply-templates select="@*|*" mode="R215" />
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(OFFERS_RECEIVED_NUMBER) or (number(OFFERS_RECEIVED_NUMBER)&lt;1)] |*[@FORM='3']//AWARD_OF_CONTRACT[not(OFFERS_RECEIVED_NUMBER)] | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE[not(OFFERS_RECEIVED_NUMBER)] | *[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R219">
		<xsl:variable name="ele">
			<xsl:choose>
				<xsl:when test="ancestor::*/@FORM='3'">AWARD_OF_CONTRACT/</xsl:when>
				<xsl:when test="ancestor::*/@FORM='18'">
					AWARD_OF_CONTRACT_DEFENCE[
					<xsl:value-of select="@ITEM" />
					]/
				</xsl:when>
				<xsl:otherwise>AWARD_AND_CONTRACT_VALUE/</xsl:otherwise>
			</xsl:choose>
			OFFERS_RECEIVED_NUMBER missing
		</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R219'" />
			<xsl:with-param name="content" select="$ele" />
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R219" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R219" />
	<xsl:template match="@*|node()" priority="-2" mode="R219">
		<xsl:apply-templates select="@*|*" mode="R219" />
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE|*[@FORM='3']//AWARD_OF_CONTRACT | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE | *[@FORM='15']//AWARD_OF_CONTRACT_DEFENCE" mode="R220">
		<xsl:choose>
			<xsl:when test="descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
			 descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::COUNTRY" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//@FORM='6'">AWARD_AND_CONTRACT_VALUE[.//OFFICIALNAME, .//TOWN, .//COUNTRY]</xsl:when>
						<xsl:when test="//@FORM='18'">
							AWARD_OF_CONTRACT_DEFENCE[
							<xsl:value-of select="@ITEM" />
							]/ECONOMIC_OPERATOR_NAME_ADDRESS[.//OFFICIALNAME, .//TOWN, .//COUNTRY]
						</xsl:when>
						<xsl:otherwise>AWARD_OF_CONTRACT/ECONOMIC_OPERATOR_NAME_ADDRESS</xsl:otherwise>
					</xsl:choose>
					missing/incomplete
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R220'" />
					<xsl:with-param name="content" select="$ele" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R220" />
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R220">
		<xsl:variable name="ele">AWARD_AND_CONTRACT_VALUE/CONTACT_DATA_WITHOUT_RESPONSIBLE_NAME_CHP missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R220'" />
			<xsl:with-param name="content" select="$ele" />
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R220" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R220" />
	<xsl:template match="@*|node()" priority="-2" mode="R220">
		<xsl:apply-templates select="@*|*" mode="R220" />
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE[.//VALUE_COST or .//LOW_VALUE])]" mode="R250">
		<xsl:variable name="ele">
			AWARD_OF_CONTRACT_DEFENCE[
			<xsl:value-of select="@ITEM" />
			]/CONTRACT_VALUE_INFORMATION/COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE[VALUE_COST or RANGE_VALUE_COST] missing
		</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R250'" />
			<xsl:with-param name="content" select="$ele" />
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R250" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R250" />
	<xsl:template match="@*|node()" priority="-2" mode="R250">
		<xsl:apply-templates select="@*|*" mode="R250" />
	</xsl:template>
	<!---->
	<xsl:template match="AWARD_OF_CONTRACT_DEFENCE[.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST]" mode="R619">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST)" />
			<xsl:when test="ancestor::*[@FORM]//TOTAL_FINAL_VALUE//@CURRENCY !=.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/@CURRENCY" />
			<xsl:when test="
			count(ancestor::*[@FORM]//TOTAL_FINAL_VALUE//*[matches(local-name(), '_VAT$')])!=
			count(.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/*[matches(local-name(), '_VAT$')])" />
			<xsl:when test="
			ancestor::*[@FORM]//TOTAL_FINAL_VALUE//*[matches(local-name(), '_VAT$')]/local-name()!=
			.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/*[matches(local-name(), '_VAT$')]/local-name()" />
			<xsl:when test="
			ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST/number()>=.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST/number()" />
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('TOTAL_FINAL_VALUE[VALUE_COST = ',	
				ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST/text(),' ',
				ancestor::*[@FORM]//TOTAL_FINAL_VALUE//@CURRENCY,
				'] and AWARD_OF_CONTRACT_DEFENCE[',./@ITEM,'][VALUE_COST = ',
				.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST/text(),' ',
				.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE//@CURRENCY,']')" />
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R619'" />
					<xsl:with-param name="content" select="$ele" />
				</xsl:call-template>
				<xsl:apply-templates select="@*|*" mode="R619" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R619" />
	<xsl:template match="@*|node()" priority="-2" mode="R619">
		<xsl:apply-templates select="@*|*" mode="R619" />
	</xsl:template>
</xsl:stylesheet>