<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section1
#  Version : R2.0.8.UK1                                   
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/UK/R2.0.8/reception">
	<xsl:template match="OFFICIALNAME[not(ancestor::MODIFIED_ADDRESS) and ancestor::CA_CE_CONCESSIONAIRE_PROFILE]" mode="R121">
		<xsl:choose>
			<xsl:when test="matches(text() ,'[^\n\r]*\w[^\n\r]*') " />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R121'" />
					<xsl:with-param name="content" select="concat('OFFICIALNAME (',&quot;'&quot;,replace(text(),'[\t\n\r]+','[NL/TAB]'),&quot;'&quot;,')')" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R121" />
	<xsl:template match="@*|node()" priority="-2" mode="R121">
		<xsl:apply-templates select="@*|*" mode="R121" />
	</xsl:template>
	<xsl:template match="*[@FORM!='8']//CA_CE_CONCESSIONAIRE_PROFILE [not(ancestor::MODIFIED_ADDRESS)]" mode="R122">
		<xsl:choose>
			<xsl:when test="TOWN[matches( text() ,'[^\n\r]*\w[^\n\r]*') ] and ADDRESS[matches( text() ,'[^\n\r]*\w[^\n\r]*') ]" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R122'" />
					<xsl:with-param name="content" select="concat('ADDRESS (',&quot;'&quot;,replace(ADDRESS/text(),'[\t\n\r]+','[NL/TAB]') ,&quot;'&quot;,') and TOWN (',&quot;'&quot;,replace(TOWN/text(),'[\t\n\r]+','[NL/TAB]') ,&quot;'&quot;,')')" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R122" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R122" />
	<xsl:template match="@*|node()" priority="-2" mode="R122">
		<xsl:apply-templates select="@*|*" mode="R122" />
	</xsl:template>
	<xsl:template match="*[@FORM!='8' and @FORM!='11']//CA_CE_CONCESSIONAIRE_PROFILE[not(ancestor::MODIFIED_ADDRESS)]" mode="R123">
		<xsl:choose>
			<xsl:when test=".//E_MAIL[matches( text() ,'\w')] " />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R123'" />
					<xsl:with-param name="content" select="'CA_CE_CONCESSIONAIRE_PROFILE//E_MAIL missing'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R123" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R123" />
	<xsl:template match="@*|node()" priority="-2" mode="R123">
		<xsl:apply-templates select="@*|*" mode="R123" />
	</xsl:template>
</xsl:stylesheet>