<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section2
#  Version : R2.0.8.UK1                                   
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/UK/R2.0.8/reception">
	<!--RULE TitleOfContract-->
	<xsl:template match="*[@FORM!='1' and @FORM!='11']//*[starts-with(local-name(),'OBJECT')] | *[starts-with(local-name(),'OBJECT_SUPPLY')] | OBJECT_WORKS_PRIOR_INFORMATION | OBJECT_CONTRACT_NOTICE_DESCRIPTION" mode="R134">
		<xsl:choose>
			<xsl:when test="descendant::*[self::TITLE_CONTRACT or 
                self::TITLE_QUALIFICATION_SYSTEM or 
                self::TITLE_NOTICE_BUYER_PROFILE or 
                self::TITLE_DESIGN_CONTACT_NOTICE or 
                self::TITLE_RESULT_DESIGN_CONTEST][descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='7']">TITLE_QUALIFICATION_SYSTEM</xsl:when>
						<xsl:when test="//*[@FORM='8']">TITLE_NOTICE_BUYER_PROFILE</xsl:when>
						<xsl:when test="//*[@FORM='12']">TITLE_DESIGN_CONTACT_NOTICE</xsl:when>
						<xsl:when test="//*[@FORM='13']">TITLE_RESULT_DESIGN_CONTEST</xsl:when>
						<xsl:otherwise>TITLE_CONTRACT</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R134'" />
					<xsl:with-param name="content" select="concat($ele, ' missing')" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R134" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R134" />
	<xsl:template match="@*|node()" priority="-2" mode="R134">
		<xsl:apply-templates select="@*|*" mode="R134" />
	</xsl:template>
	<!--RULE shortContractDescription-->
	<xsl:template match="*[@FORM='1'or @FORM='16']//TOTAL_QUANTITY_OR_SCOPE[not(ancestor::LOT_PRIOR_INFORMATION)] | 
        SHORT_CONTRACT_DESCRIPTION | 
        DESCRIPTION_OF_CONTRACT | 
        SHORT_DESCRIPTION |
        *[@FORM='7'or @FORM='13']//DESCRIPTION |
        SHORT_DESCRIPTION_CONTRACT" mode="R135">
		<xsl:choose>
			<xsl:when test="descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='1' or @FORM='16']">TOTAL_QUANTITY_OR_SCOPE</xsl:when>
						<xsl:when test="//*[@FORM='2' or @FORM='3' or @FORM='5' or @FORM='15' or @FORM='17' or @FORM='18' or @FORM='T01' or @FORM='T02']">SHORT_CONTRACT_DESCRIPTION</xsl:when>
						<xsl:when test="//*[@FORM='4' or @FORM='10']">DESCRIPTION_OF_CONTRACT</xsl:when>
						<xsl:when test="//*[@FORM='6']">SHORT_DESCRIPTION</xsl:when>
						<xsl:when test="//*[@FORM='7' or @FORM='13']">DESCRIPTION</xsl:when>
						<xsl:otherwise>SHORT_DESCRIPTION_CONTRACT</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R135'" />
					<xsl:with-param name="content" select="concat($ele, ' missing')" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R135" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R135" />
	<xsl:template match="@*|node()" priority="-2" mode="R135">
		<xsl:apply-templates select="@*|*" mode="R135" />
	</xsl:template>
	<!--RULE TypeAndNatureContract-->
	<!-- F2,3,5,6,15,17,18,19,4app-->
	<xsl:template match="*[@FORM!='16' and @FORM!='8' and @FORM!='9']//TYPE_CONTRACT" priority="1006" mode="R137">
		<xsl:choose>
			<xsl:when test="following-sibling::*[child::* or attribute::* or matches(local-name(),'SERVICE')]" />
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">(ANNEX_I) </xsl:if>
					The type (
					<xsl:value-of select="./@VALUE" />
					) and the nature (unknown!)
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="$ele" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!--F4app, contract type optional!-->
	<xsl:template match="ANNEX_I" priority="1005" mode="R137">
		<xsl:choose>
			<xsl:when test=".//TYPE_CONTRACT" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="'(ANNEX_I) The type (unknown!) and the nature (unknown!)'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!--F4-->
	<xsl:template match="*[@FORM='4']//*[@CONTRACT_TYPE='SERVICES']" priority="1004" mode="R137">
		<xsl:choose>
			<xsl:when test=".[@SERVICES_CATEGORY]" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="'The type (SERVICES) and the nature (service category unknown!)'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!--F16-->
	<xsl:template match="TYPE_CONTRACT[@VALUE='SERVICES']" priority="1003" mode="R137">
		<xsl:choose>
			<xsl:when test="following-sibling::SERVICE_CATEGORY_DEFENCE" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="'The type (SERVICES) and the nature (service category unknown!)'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!-- F10-->
	<xsl:template match="*[@FORM='10']" priority="1002" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F10_CONTRACT_TYPE/*" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="'The nature (unknown!)'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!--F11 -->
	<xsl:template match="*[@FORM='11']" priority="1001" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F11_CONTRACT_TYPE/*" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="'The nature (unknown!)'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<!--F7 -->
	<xsl:template match="OBJECT_QUALIFICATION_SYSTEM" priority="1000" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F07_CONTRACT_TYPE[@VALUE='WORKS' or @VALUE='SUPPLIES']" />
			<xsl:when test=".//F07_CONTRACT_TYPE[@VALUE='SERVICES'] and .//SERVICE_CATEGORY" />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'" />
					<xsl:with-param name="content" select="''" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R137" />
	<xsl:template match="@*|node()" priority="-2" mode="R137">
		<xsl:apply-templates select="@*|*" mode="R137" />
	</xsl:template>
	<!--PATTERN OneAndOnlyContractType-->
	<xsl:template match="*[@FORM]" mode="R139">
		<xsl:choose>
			<xsl:when test="not(
                (
                (
                .//node()[string(@*[1])='SERVICES']|
                .//attribute::SERVICES_CATEGORY|
                .//SERVICE_CATEGORY|.//SERVICE_CATEGORY_PUB|.//SERVICE_CATEGORY_PUB_DEFENCE|.//SERVICE_CATEGORY_DEFENCE                  
                ) 
                and                 
                (
                (.//node()[string(@*[1])='SUPPLIES']|.//SUPPLIES|.//TYPE_SUPPLIES_CONTRACT) 
                or 
                (.//node()[string(@*[1])='WORKS']|.//TYPE_WORK_CONTRACT|.//OBJECT_WORKS_PRIOR_INFORMATION)
                )
                )
                or 
                (
                (.//node()[string(@*[1])='SUPPLIES']|.//SUPPLIES|.//TYPE_SUPPLIES_CONTRACT) and
                (.//node()[string(@*[1])='WORKS']|.//TYPE_WORK_CONTRACT|.//OBJECT_WORKS_PRIOR_INFORMATION)
                )                
                ) " />
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R139'" />
					<xsl:with-param name="content" select="''" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R139" />
	<xsl:template match="@*|node()" priority="-2" mode="R139">
		<xsl:apply-templates select="@*|*" mode="R139" />
	</xsl:template>
	<!---->
	<xsl:template match="*[./CPV and .//TYPE_CONTRACT]" mode="R390">
		<xsl:variable name="error_nb">
			<xsl:value-of select="
			count(.[.//TYPE_CONTRACT/@*='SUPPLIES']/CPV/CPV_MAIN/CPV_CODE[not(45>number(substring(@*,1,2)) or number(substring(@*,1,2))=48)])
			+ count(.[.//TYPE_CONTRACT/@*='WORKS']/CPV/CPV_MAIN/CPV_CODE[number(substring(@*,1,2))!=45])
			+ count(.[.//TYPE_CONTRACT/@*='SERVICES']/CPV/CPV_MAIN/CPV_CODE[49>number(substring(@*,1,2)) or number(substring(@*,1,2))>98])" />
		</xsl:variable>
		<xsl:choose>
			<!--<xsl:when test="ancestor::*[@FORM='18']"/>-->
			<xsl:when test="$error_nb>0">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R390'" />
					<xsl:with-param name="content" select="concat(./local-name(),'[',.//TYPE_CONTRACT/@*,', ',./CPV/CPV_MAIN/CPV_CODE/@*,']')" />
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R390" />
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R390" />
	<xsl:template match="@*|node()" priority="-2" mode="R390">
		<xsl:apply-templates select="@*|*" mode="R390" />
	</xsl:template>
</xsl:stylesheet>