<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section4
#  Version : R2.0.8.S05                                   
#  Intermediate release number : 22/10/2020                               
#  Last update : 09/12/2019                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/ted/R2.0.8/reception">
	<!-- Pattern ProcedureType -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15' or @FORM='18']| *[@FORM='4'][.//ANNEX_I]" mode="R178">
		<xsl:choose>
			<xsl:when test=".[@FORM='3']//TYPE_OF_PROCEDURE_DEF/*"/>
			<xsl:when test=".[@FORM='4']//ANNEX_I//F04_TYPE_PROCEDURE/@TYPE"/>
			<xsl:when test=".[@FORM='6']//TYPE_PROCEDURE_AWARD/*"/>
			<xsl:when test=".[@FORM='15']//TYPE_OF_PROCEDURE_DEF_F15/*"/>
			<xsl:when test=".[@FORM='18']//TYPE_OF_PROCEDURE_CONTRACT_AWARD_DEFENCE/*"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='3' or @FORM='6'">PT_OPEN|PT_RESTRICTED...</xsl:when>
						<xsl:when test="@FORM='4'">(ANNEX_I) F04_TYPE_PROCEDURE</xsl:when>
						<xsl:when test="@FORM='15'">F15_PT_NEGOTIATED_WITHOUT_COMPETITION|F15_AWARD_WITHOUT_PRIOR_PUBLICATION</xsl:when>
						<xsl:when test="@FORM='18'">PT_RESTRICTED|PT_ACCELERATED_RESTRICTED...</xsl:when>
					</xsl:choose> missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R178'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R178"/>
	<xsl:template match="@*|node()" priority="-2" mode="R178">
		<xsl:apply-templates select="@*|*" mode="R178"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM][.//SERVICE_CATEGORY_PUB]" mode="R179">
		<xsl:choose>
			<xsl:when test=".//SERVICE_CATEGORY_PUB[not(matches(text(),'^(1[7-9]|2[0-7])N$'))]"/>
			<xsl:when test=".//SERVICE_CATEGORY_PUB[matches(text(),'^(1[7-9]|2[0-7])N$')] and .//*[matches(local-name(),'AWARD_WITHOUT_PRIOR_PUBLICATION')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">SERVICE_CATEGORY_PUB='<xsl:value-of select=".//SERVICE_CATEGORY_PUB"/>'<xsl:choose>
						<xsl:when test=".//*[matches(local-name(),'TYPE.*PROC')]/*"> and <xsl:value-of select="local-name(.//*[matches(local-name(),'TYPE.*PROC')]/*)"/> inconsistent</xsl:when>
						<xsl:when test="*[@FORM='3']"> and F03_AWARD_WITHOUT_PRIOR_PUBLICATION missing</xsl:when>
						<xsl:when test="*[@FORM='6']"> and F06_AWARD_WITHOUT_PRIOR_PUBLICATION missing</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R179'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R179"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R179"/>
	<xsl:template match="@*|node()" priority="-2" mode="R179">
		<xsl:apply-templates select="@*|*" mode="R179"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM!='14'][.//*[matches(local-name(),'AWARD_WITHOUT_PRIOR_PUBLICATION|PT_NEGOTIATED_WITHOUT_COMPETITION')]]" mode="R180">
		<xsl:choose>
			<xsl:when test="(descendant::JUSTI_CHOICE_COMPETITION_CONTRACT_AWARD_UTILITIES|descendant::*[matches(local-name(),'ANNEX_D(.)?$')])[child::*]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'AWARD_WITHOUT_PRIOR_PUBLICATION|PT_NEGOTIATED_WITHOUT_COMPETITION')])"/>
					<xsl:choose>
						<xsl:when test="@FORM='3' or @FORM='15'"> - ANNEX_D..</xsl:when>
						<xsl:when test="@FORM='6'"> - JUSTI_CHOICE_COMPETITION_CONTRACT_AWARD_UTILITIES</xsl:when>
					</xsl:choose> missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R180'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R180"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R180"/>
	<xsl:template match="@*|node()" priority="-2" mode="R180">
		<xsl:apply-templates select="@*|*" mode="R180"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='5'][.//PT_NEGOTIATED_CHOICE | .//node()[string(@*)='NEGOTIATED']][not(.//IS_CANDIDATE_SELECTED)]" mode="R181">
		<xsl:variable name="ele">PT_NEGOTIATED_CHOICE and  IS_CANDIDATE_SELECTED missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R181'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R181"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R181"/>
	<xsl:template match="@*|node()" priority="-2" mode="R181">
		<xsl:apply-templates select="@*|*" mode="R181"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12']//RESTRICTED_CONTEST" mode="R182">
		<xsl:choose>
			<xsl:when test="descendant::PARTICIPANTS_NUMBER[number()>0] or (descendant::MIN_PARTICIPANTS_NUMBER[number()>0] and number(descendant::MAX_PARTICIPANTS_NUMBER)>number(descendant::MIN_PARTICIPANTS_NUMBER))"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{PARTICIPANTS_NUMBER,MIN_PARTICIPANTS_NUMBER,MAX_PARTICIPANTS_NUMBER} missing/incorrect</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R182'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R182"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R182"/>
	<xsl:template match="@*|node()" priority="-2" mode="R182">
		<xsl:apply-templates select="@*|*" mode="R182"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='4' or @FORM='5'][.//SETTING_UP_DPS][not(.//node()[string(@*[1])='OPEN'] or .//PT_OPEN)]" mode="R183">
		<xsl:choose>
			<xsl:when test="not(descendant::*[matches(local-name(),'TYPE.*PROC.*')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2'">
							<xsl:value-of select="local-name(.//*[matches(local-name(),'_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select=".//*[matches(local-name(),'TYPE.*PROC')]/@*"/>
						</xsl:otherwise>
					</xsl:choose> and <xsl:if test="@FORM='4'">(ANNEX_I)</xsl:if> SETTING_UP_DPS inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R183'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R183"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R183"/>
	<xsl:template match="@*|node()" priority="-2" mode="R183">
		<xsl:apply-templates select="@*|*" mode="R183"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='4'][.//NOTICE_CALL_COMPETITION and .//node()[string(@*[1])='OPEN']]" priority="1001" mode="R184">
		<xsl:variable name="ele">(ANNEX_I) NOTICE_CALL_COMPETITION and OPEN procedure inconsistent</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R184'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R184"/>
	</xsl:template>
	<xsl:template match="*[@FORM='4'][.//NOTICE_TIME_LIMITS_RECEIPT_TENDERS and not(.//node()[string(@*[1])='OPEN'])]" priority="1000" mode="R184">
		<xsl:choose>
			<xsl:when test="not(descendant::*[matches(local-name(),'TYPE.*PROC.*')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) NOTICE_TIME_LIMITS_RECEIPT_TENDERS and <xsl:value-of select=".//*[matches(local-name(),'TYPE.*PROC')]/@*"/> procedure inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R184'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R184"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R184"/>
	<xsl:template match="@*|node()" priority="-2" mode="R184">
		<xsl:apply-templates select="@*|*" mode="R184"/>
	</xsl:template>
	<!-- Pattern review-->
	<xsl:template match="*[@FORM='2']" mode="R185">
		<xsl:choose>
			<xsl:when test="not(.//MAXIMUM_NUMBER_INVITED/*) and .//PT_OPEN"/>
			<xsl:when test=".//*[matches(local-name(),'NEGOTIATED|DIALOGUE')] and not(.//REDUCTION_OF_THE_NUMBER)"/>
			<xsl:when test="(.//*[matches(local-name(),'_RESTRICTED')] or (.//*[matches(local-name(),'NEGOTIATED|DIALOGUE')] and .//REDUCTION_OF_THE_NUMBER/string(@*)='YES'))
                and .//MAXIMUM_NUMBER_INVITED[
                (OPE_ENVISAGED_NUMBER|OPE_MINIMUM_NUMBER) and 
                OPE_OBJECTIVE_CRITERIA[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
					<xsl:if test=".//*[matches(local-name(),'NEGOTIATED|DIALOGUE')]">, REDUCTION_OF_THE_NUMBER='<xsl:value-of select=".//REDUCTION_OF_THE_NUMBER/@*"/>'</xsl:if>
					<xsl:choose>
						<xsl:when test=".//*[matches(local-name(),'_RESTRICTED')] or (.//*[matches(local-name(),'NEGOTIATED|DIALOGUE')] and .//REDUCTION_OF_THE_NUMBER/string(@*)='YES')"> - OPE_ENVISAGED_NUMBER/OPE_MINIMUM_NUMBER/OPE_OBJECTIVE_CRITERIA empty/missing</xsl:when>
						<xsl:otherwise> and MAXIMUM_NUMBER_INVITED/* inconsistent</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R185'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R185"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R185"/>
	<xsl:template match="@*|node()" priority="-2" mode="R185">
		<xsl:apply-templates select="@*|*" mode="R185"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2'][.//*[matches(local-name(),'NEGOTIATED|DIALOGUE')] or .//REDUCTION_OF_THE_NUMBER]" mode="R186">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'NEGOTIATED|DIALOGUE')] and .//REDUCTION_OF_THE_NUMBER"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
					<xsl:choose>
						<xsl:when test=".//REDUCTION_OF_THE_NUMBER"> and REDUCTION_OF_THE_NUMBER='<xsl:value-of select=".//REDUCTION_OF_THE_NUMBER/@*"/>' inconsistent</xsl:when>
						<xsl:otherwise> - REDUCTION_OF_THE_NUMBER missing</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R186'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R186"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R186"/>
	<xsl:template match="@*|node()" priority="-2" mode="R186">
		<xsl:apply-templates select="@*|*" mode="R186"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='10' or @FORM='11']" mode="R187">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'AWARD_CRITERIA')][descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='10'">AWARD_CRITERIA_CONCESSION</xsl:when>
						<xsl:otherwise>AWARD_CRITERIA_CONTRACT_CONCESSIONAIRE</xsl:otherwise>
					</xsl:choose> empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R187'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R187"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R187"/>
	<xsl:template match="@*|node()" priority="-2" mode="R187">
		<xsl:apply-templates select="@*|*" mode="R187"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12'][.//RESTRICTED_CONTEST]" mode="R188">
		<xsl:choose>
			<xsl:when test=".//NAME[parent::PARTICIPANTS_NAME and matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">RESTRICTED_CONTEST - NAME empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R188'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R188"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R188"/>
	<xsl:template match="@*|node()" priority="-2" mode="R188">
		<xsl:apply-templates select="@*|*" mode="R188"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='3' or @FORM='5']" mode="R189">
		<xsl:choose>
			<xsl:when test=".//LOWEST_PRICE|.//CRITERIA_STATED_IN_OTHER_DOCUMENT|.//CRITERIA_DEFINITION"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{LOWEST_PRICE,CRITERIA_STATED_IN_OTHER_DOCUMENT,CRITERIA,WEIGHTING} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R189'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R189"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R189"/>
	<xsl:template match="@*|node()" priority="-2" mode="R189">
		<xsl:apply-templates select="@*|*" mode="R189"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='4']//CRITERIA_STATED_BELOW" mode="R190">
		<xsl:choose>
			<xsl:when test="CRITERIA_DEFINITION"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) CRITERIA_STATED_BELOW - {CRITERIA,WEIGHTING} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R190'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R190"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R190"/>
	<xsl:template match="@*|node()" priority="-2" mode="R190">
		<xsl:apply-templates select="@*|*" mode="R190"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='2' or @FORM='3' or @FORM='4' or @FORM='5'][.//CRITERIA_DEFINITION[not(CRITERIA and WEIGHTING)]]" mode="R254">
		<xsl:variable name="ele">Total CRITERIA_DEFINITION(<xsl:value-of select="count(.//CRITERIA_DEFINITION)"/>)/Total ORDER(<xsl:value-of select="count(.//CRITERIA_DEFINITION/ORDER_C)"/>)/Total CRITERIA(<xsl:value-of select="count(.//CRITERIA_DEFINITION/CRITERIA[matches(text(),'[\p{L}\p{N}]+')])"/>)/Total WEIGHTING(<xsl:value-of select="count(.//CRITERIA_DEFINITION/WEIGHTING[number(translate(text(),', ','.'))>0])"/>)</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R254'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R254"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R254"/>
	<xsl:template match="@*|node()" priority="-2" mode="R254">
		<xsl:apply-templates select="@*|*" mode="R254"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2'][.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED')] or .//*[matches(local-name(),'ELECTRONIC_AUCTION$')]]" mode="R191">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED')] and .//*[matches(local-name(),'ELECTRONIC_AUCTION$')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
					<xsl:choose>
						<xsl:when test=".//*[matches(local-name(),'ELECTRONIC_AUCTION$')]"> and <xsl:value-of select="local-name(.//*[matches(local-name(),'ELECTRONIC_AUCTION$')])"/> inconsistent</xsl:when>
						<xsl:otherwise> - (NO_)USE_ELECTRONIC_AUCTION missing</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R191'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R191"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R191"/>
	<xsl:template match="@*|node()" priority="-2" mode="R191">
		<xsl:apply-templates select="@*|*" mode="R191"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='7']" mode="R193">
		<xsl:choose>
			<xsl:when test=".//RENEWAL_QUALIFICATION_SYSTEM[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')] or .//NO_RENEWAL_QUALIFICATION_SYSTEM"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(NO_)RENEWAL_QUALIFICATION_SYSTEM empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R193'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R193"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R193"/>
	<xsl:template match="@*|node()" priority="-2" mode="R193">
		<xsl:apply-templates select="@*|*" mode="R193"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='9'][not(.//NOTICE_NUMBER_OJ)]" mode="R194">
		<xsl:variable name="ele">NOTICE_NUMBER_OJ missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R194'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R194"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R194"/>
	<xsl:template match="@*|node()" priority="-2" mode="R194">
		<xsl:apply-templates select="@*|*" mode="R194"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12']" mode="R196">
		<xsl:choose>
			<xsl:when test=".//CRITERIA_EVALUATION_PROJECTS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">CRITERIA_EVALUATION_PROJECTS empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R196'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R196"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R196"/>
	<xsl:template match="@*|node()" priority="-2" mode="R196">
		<xsl:apply-templates select="@*|*" mode="R196"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='13'][not(.//NO_PREVIOUS_PUBLICATION and .//NOTICE_NUMBER_OJ)]" mode="R197">
		<xsl:variable name="ele">{NO_PREVIOUS_PUBLICATION,NOTICE_NUMBER_OJ} missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R197'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R197"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R197"/>
	<xsl:template match="@*|node()" priority="-2" mode="R197">
		<xsl:apply-templates select="@*|*" mode="R197"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='3' or @FORM='5' or @FORM='6'][not(.//*[matches(local-name(),'PREVIOUS_PUBLICATION_EXISTS')])]" mode="R255">
		<xsl:variable name="ele">(NO_)PREVIOUS_PUBLICATION_EXISTS_F<xsl:value-of select="@FORM"/> missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R255'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R255"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R255"/>
	<xsl:template match="@*|node()" priority="-2" mode="R255">
		<xsl:apply-templates select="@*|*" mode="R255"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2']//*[*[string(@*[1])='PRIOR_INFORMATION_NOTICE']]" mode="R198">
		<xsl:choose>
			<xsl:when test="NOTICE_NUMBER_OJ|DATE_OJ"/>
			<xsl:otherwise>
				<xsl:variable name="ele">PRIOR_INFORMATION_NOTICE - {NOTICE_NUMBER_OJ,DATE_OJ} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R198'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R198"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R198"/>
	<xsl:template match="@*|node()" priority="-2" mode="R198">
		<xsl:apply-templates select="@*|*" mode="R198"/>
	</xsl:template>
	<!-- Pattern review-->
	<xsl:template match="*[@FORM='3'][.//*[matches(local-name(),'NO_PREVIOUS_PUBLICATION_EXISTS')]]" mode="R199">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'AWARD_WITHOUT_PRIOR_PUBLICATION')]"/>
			<xsl:when test="not(.//*[matches(local-name(),'PT_OPEN|(T|D)_RESTRICTED|PT.*NEGOTIATED|DIALOGUE')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|(T|D)_RESTRICTED|PT.*NEGOTIATED|DIALOGUE')])"/> and NO_PREVIOUS_PUBLICATION_EXISTS_F<xsl:value-of select="@FORM"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R199'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R199"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R199"/>
	<xsl:template match="@*|node()" priority="-2" mode="R199">
		<xsl:apply-templates select="@*|*" mode="R199"/>
	</xsl:template>
	<!-- Pattern review-->
	<xsl:template match="*[@FORM='6'][.//*[matches(local-name(),'NO_PREVIOUS_PUBLICATION_EXISTS')]]" mode="R200">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'NEGOTIATED_WITHOUT_COMPE|AWARD_WITHOUT_PRIOR_PUBLICATION')]"/>
			<xsl:when test="not(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|PT.*NEGOTIATED')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|PT.*NEGOTIATED|AWARD_WITHOUT_PRIOR_PUBLICATION')])"/> and NO_PREVIOUS_PUBLICATION_EXISTS_F06 inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R200'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R200"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R200"/>
	<xsl:template match="@*|node()" priority="-2" mode="R200">
		<xsl:apply-templates select="@*|*" mode="R200"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='5' or @FORM='6'][.//*[matches(local-name(),'^PREVIOUS_PUBLICATION_EXISTS')]]" mode="R256">
		<xsl:choose>
			<xsl:when test=".[@FORM='3']//*[matches(local-name(),'CNT_NOTICE_INFORMATION')][*[@*]][NOTICE_NUMBER_OJ|DATE_OJ]"/>
			<xsl:when test=".[@FORM='5']//*[matches(local-name(),'PREVIOUS_PUBLICATION_NOTICE')][*[@*]][NOTICE_NUMBER_OJ|DATE_OJ]"/>
			<xsl:when test=".[@FORM='6']//*[matches(local-name(),'PREVIOUS_PUBLICATION_NOTICE|CNT_NOTICE_INFORMATION')][*[@*]][NOTICE_NUMBER_OJ|DATE_OJ]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='3'">PREVIOUS_PUBLICATION_EXISTS_F3 - CONTRACT_NOTICE/SIMPLIFIED_CONTRACT_NOTICE_DPS/NOTICE_NUMBER_OJ/DATE_OJ (from CNT_NOTICE_INFORMATION) missing</xsl:when>
						<xsl:when test="@FORM='5'">PREVIOUS_PUBLICATION_EXISTS_F5 - NOTICE_BUYER_PROFILE/PERIODIC_INDICATIVE_NOTICE/NOTICE_NUMBER_OJ/DATE_OJ missing</xsl:when>
						<xsl:when test="@FORM='6'">PREVIOUS_PUBLICATION_EXISTS_F6 - NOTICE_QUALIFICATION_SYSTEM/PERIODIC_INDICATIVE_NOTICE/NOTICE_BUYER_PROFILE/CONTRACT_NOTICE/SIMPLIFIED_CONTRACT_NOTICE_DPS/NOTICE_NUMBER_OJ/DATE_OJ missing</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R256'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R256"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R256"/>
	<xsl:template match="@*|node()" priority="-2" mode="R256">
		<xsl:apply-templates select="@*|*" mode="R256"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='4' or @FORM='5'][.//CONDITIONS_OBTAINING_SPECIFICATIONS/*][.//SETTING_UP_DPS]" mode="R202">
		<xsl:variable name="ele">
			<xsl:if test="@FORM='4'">(ANNEX_I) </xsl:if>SETTING_UP_DPS and CONDITIONS_OBTAINING_SPECIFICATIONS inconsistent</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R202'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R202"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R202"/>
	<xsl:template match="@*|node()" priority="-2" mode="R202">
		<xsl:apply-templates select="@*|*" mode="R202"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='4'][.//ANNEX_I][not(.//SETTING_UP_DPS)]" mode="R203">
		<xsl:choose>
			<xsl:when test=".//NO_PAYABLE_DOCUMENTS or 
                (.//DOCUMENT_COST[number(translate(text(),', ','.'))>0] and 
                .//DOCUMENT_METHOD_OF_PAYMENT[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) {NO_PAYABLE_DOCUMENTS,DOCUMENT_COST,DOCUMENT_METHOD_OF_PAYMENT} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R203'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R203"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R203"/>
	<xsl:template match="@*|node()" priority="-2" mode="R203">
		<xsl:apply-templates select="@*|*" mode="R203"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='5'][not(.//SETTING_UP_DPS)][.//*[string(@*)='OPEN'] or .//PT_OPEN][.//CONDITIONS_OBTAINING_SPECIFICATIONS/*]" mode="R204">
		<xsl:choose>
			<xsl:when test=".//NO_PAYABLE_DOCUMENTS or 
                (.//DOCUMENT_COST[number(translate(text(),', ','.'))>0] and 
                .//DOCUMENT_METHOD_OF_PAYMENT[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{NO_PAYABLE_DOCUMENTS,DOCUMENT_COST,DOCUMENT_METHOD_OF_PAYMENT} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R204'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R204"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R204"/>
	<xsl:template match="@*|node()" priority="-2" mode="R204">
		<xsl:apply-templates select="@*|*" mode="R204"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='4'][.//NOTICE_CALL_COMPETITION|.//DATE_LIMIT_RECEIPT_INTEREST]" mode="R205">
		<xsl:choose>
			<xsl:when test=".//NOTICE_CALL_COMPETITION and .//DATE_LIMIT_RECEIPT_INTEREST"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) <xsl:choose>
						<xsl:when test=".//NOTICE_CALL_COMPETITION">NOTICE_CALL_COMPETITION - DATE_LIMIT_RECEIPT_INTEREST missing</xsl:when>
						<xsl:otherwise>NOTICE_TIME_LIMITS_RECEIPT_TENDERS and DATE_LIMIT_RECEIPT_INTEREST inconsistent</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R205'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R205"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R205"/>
	<xsl:template match="@*|node()" priority="-2" mode="R205">
		<xsl:apply-templates select="@*|*" mode="R205"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='4'][.//NOTICE_TIME_LIMITS_RECEIPT_TENDERS|.//DATE_LIMIT_RECEIPT_APPLICATION]" mode="R206">
		<xsl:choose>
			<xsl:when test=".//NOTICE_TIME_LIMITS_RECEIPT_TENDERS and .//DATE_LIMIT_RECEIPT_APPLICATION"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) <xsl:choose>
						<xsl:when test=".//NOTICE_TIME_LIMITS_RECEIPT_TENDERS">NOTICE_TIME_LIMITS_RECEIPT_TENDERS - DATE_LIMIT_RECEIPT_APPLICATION missing</xsl:when>
						<xsl:otherwise>NOTICE_CALL_COMPETITION and DATE_LIMIT_RECEIPT_APPLICATION inconsistent</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R206'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R206"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R206"/>
	<xsl:template match="@*|node()" priority="-2" mode="R206">
		<xsl:apply-templates select="@*|*" mode="R206"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2'][.//DISPATCH_INVITATIONS_DATE]" mode="R207">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'_RESTRICTED|NEGOTIATED|DIALOGUE')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/> and DISPATCH_INVITATIONS_DATE inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R207'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R207"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R207"/>
	<xsl:template match="@*|node()" priority="-2" mode="R207">
		<xsl:apply-templates select="@*|*" mode="R207"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12'][.//DISPATCH_INVITATIONS_DATE]" mode="R208">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'RESTRICTED')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'OPEN|RESTRICTED')])"/> and DISPATCH_INVITATIONS_DATE inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R208'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R208"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R208"/>
	<xsl:template match="@*|node()" priority="-2" mode="R208">
		<xsl:apply-templates select="@*|*" mode="R208"/>
	</xsl:template>
	<!-- Pattern -->
	<!--<xsl:template match="*[@FORM='2'or @FORM='5' or @FORM='10' or @FORM='11' or @FORM='12'] | *[@FORM='4']//ANNEX_I" mode="R209">
		<xsl:choose>
			<xsl:when test=".//LANGUAGE_ANY_EC[@*='YES']|.//LANGUAGE_EC|.//LANGUAGE_OTHER[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">(ANNEX_I) </xsl:if>LANGUAGE_ANY_EC/LANGUAGE_EC/LANGUAGE_OTHER empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R209'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R209"/>
	</xsl:template>-->
	<xsl:template match="*[@FORM='17' or @FORM='19'][not(.//LANGUAGE) or .//LANGUAGE_ANY_EC/@*='NO']" mode="R209">
		<xsl:choose>
			<xsl:when test=".//LANGUAGE_OTHER[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="not(.//LANGUAGE)">LANGUAGE missing</xsl:if>
					<xsl:if test=".//LANGUAGE_ANY_EC/@*='NO'">LANGUAGE_ANY_EC/@*='NO' and LANGUAGE_OTHER empty/missing</xsl:if>
					</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R209'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R209"/>
	</xsl:template>	
	<xsl:template match="text()" priority="-1" mode="R209"/>
	<xsl:template match="@*|node()" priority="-2" mode="R209">
		<xsl:apply-templates select="@*|*" mode="R209"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2'or @FORM='5']" mode="R210">
		<xsl:choose>
			<xsl:when test="(.//*[string(@*)='OPEN'] or .//PT_OPEN) and .//MINIMUM_TIME_MAINTAINING_TENDER[(PERIOD_DAY|PERIOD_MONTH)[number(translate(text(),', ','.'))>0]]"/>
			<xsl:when test="(.//*[string(@*)='OPEN'] or .//PT_OPEN) and .//MINIMUM_TIME_MAINTAINING_TENDER/UNTIL_DATE"/>
			<xsl:when test="not(.//*[string(@*)='OPEN'] or .//PT_OPEN) and not(.//MINIMUM_TIME_MAINTAINING_TENDER)"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
					<xsl:value-of select=".//TYPE_OF_PROCEDURE_DETAIL/@*"/>
					<xsl:choose>
						<xsl:when test="(.//*[string(@*)='OPEN'] or .//PT_OPEN)"> - MINIMUM_TIME_MAINTAINING_TENDER/* incorrect/missing</xsl:when>
						<xsl:otherwise> and MINIMUM_TIME_MAINTAINING_TENDER inconsistent</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R210'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R210"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R210"/>
	<xsl:template match="@*|node()" priority="-2" mode="R210">
		<xsl:apply-templates select="@*|*" mode="R210"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2'or @FORM='5'][not(.//*[string(@*)='OPEN'] or .//PT_OPEN)][.//CONDITIONS_FOR_OPENING_TENDERS/*]" mode="R211R212">
		<xsl:variable name="ele">
			<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/>
			<xsl:value-of select=".//TYPE_OF_PROCEDURE_DETAIL/@*"/> and CONDITIONS_FOR_OPENING_TENDERS/* inconsistent</xsl:variable>
		<xsl:choose>
			<xsl:when test="@FORM='2'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R211'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R212'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R211R212"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R211R212"/>
	<xsl:template match="@*|node()" priority="-2" mode="R211R212">
		<xsl:apply-templates select="@*|*" mode="R211R212"/>
	</xsl:template>
	<!--test-->
	<xsl:template match="*[@FORM='2'][.//PT_OPEN]" mode="R211">
		<xsl:choose>
			<xsl:when test=".//CONDITIONS_FOR_OPENING_TENDERS[DATE_TIME[TIME] and (.//PLACE_NOT_STRUCTURED[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')] or (.//OFFICIALNAME[matches(text(),'[\p{L}\p{N}]+')] and .//ADDRESS[matches(text(),'[\p{L}\p{N}]+')] and .//TOWN [matches(text(),'[\p{L}\p{N}]+')])) and (EXISTENCE_AUTHORISED_PERSONS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]|NO_EXISTENCE_AUTHORISED_PERSONS)]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.//*[matches(local-name(),'PT_OPEN|_RESTRICTED|NEGOTIATED|DIALOGUE')])"/> - DATE_TIME/OFFICIALNAME/ADDRESS/TOWN/PLACE_NOT_STRUCTURED/(NO_)EXISTENCE_AUTHORISED_PERSONS empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R211'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R211"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R211"/>
	<xsl:template match="@*|node()" priority="-2" mode="R211">
		<xsl:apply-templates select="@*|*" mode="R211"/>
	</xsl:template>
	<xsl:template match="*[@FORM='5'][.//*[string(@*)='OPEN']]" mode="R212">
		<xsl:choose>
			<xsl:when test=".//CONDITIONS_FOR_OPENING_TENDERS[DATE_TIME and .//OFFICIALNAME[matches(text(),'[\p{L}\p{N}]+')] and .//ADDRESS[matches(text(),'[\p{L}\p{N}]+')] and .//TOWN [matches(text(),'[\p{L}\p{N}]+')]]"/>
			<xsl:when test=".//CONDITIONS_FOR_OPENING_TENDERS[DATE_TIME and .//PLACE_NOT_STRUCTURED[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_OF_PROCEDURE_DETAIL/@*"/> - DATE_TIME,OFFICIALNAME,ADDRESS,TOWN,PLACE_NOT_STRUCTURED empty/missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R212'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R212"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R212"/>
	<xsl:template match="@*|node()" priority="-2" mode="R212">
		<xsl:apply-templates select="@*|*" mode="R212"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12'][not(.//FOLLOW_UP_CONTRACTS|.//NO_FOLLOW_UP_CONTRACTS)]" mode="R213">
		<xsl:variable name="ele">(NO_)FOLLOW_UP_CONTRACTS missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R213'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R213"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R213"/>
	<xsl:template match="@*|node()" priority="-2" mode="R213">
		<xsl:apply-templates select="@*|*" mode="R213"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='12'][not(.//DECISION_BINDING_CONTRACTING | .//NO_DECISION_BINDING_CONTRACTING)]" mode="R214">
		<xsl:variable name="ele">(NO_)DECISION_BINDING_CONTRACTING missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R214'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R214"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R214"/>
	<xsl:template match="@*|node()" priority="-2" mode="R214">
		<xsl:apply-templates select="@*|*" mode="R214"/>
	</xsl:template>
		<!---->
	<xsl:template match="RECEIPT_LIMIT_DATE|DATE_LIMIT_RECEIPT_INTEREST|DATE_LIMIT_RECEIPT_APPLICATION|TIME_LIMIT_CHP|F11_TIME_LIMIT_TYPE" mode="R557">
		<xsl:if test=".//YEAR[not(matches(normalize-space(text()),'^20'))]">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R557'"/>
				<xsl:with-param name="content" select="concat(local-name(.),'//YEAR=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R557"/>
	<xsl:template match="@*|node()" priority="-2" mode="R557">
		<xsl:apply-templates select="@*|*" mode="R557"/>
	</xsl:template>
		<!---->
	<xsl:template match="CONDITIONS_FOR_OPENING_TENDERS//YEAR" mode="R558">
		<xsl:if test="not(matches(normalize-space(text()),'^20'))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R558'"/>
				<xsl:with-param name="content" select="concat('CONDITIONS_FOR_OPENING_TENDERS//YEAR=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R558"/>
	<xsl:template match="@*|node()" priority="-2" mode="R558">
		<xsl:apply-templates select="@*|*" mode="R558"/>
	</xsl:template>
</xsl:stylesheet>
