<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : annexD
#  Version : R2.0.8.S05                                        
#  Intermediate release number : 22/10/2020                                 
#  Last update : 14/04/2016                                                           
####################################################################################
 -->
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<!-- Pattern -->
	<xsl:template match="*[@FORM='15'][.//ANNEX_D_F15/*]" mode="R240">
		<xsl:choose>
			<xsl:when test=".//@NOTICE='CONTRACTING_AUTHORITY' and .//ANNEX_D1"/>
			<xsl:when test=".//@NOTICE='CONTRACTING_ENTITY' and .//ANNEX_D2"/>
			<xsl:when test=".//@NOTICE='CONTRACTING_DEFENCE' and .//ANNEX_D3"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//@NOTICE"/> and <xsl:value-of select="local-name(.//ANNEX_D_F15/*)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R240'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R240"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R240"/>
	<xsl:template match="@*|node()" priority="-2" mode="R240">
		<xsl:apply-templates select="@*|*" mode="R240"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15']//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')]" mode="R241">
		<xsl:choose>
			<xsl:when test="./*/child::* and not(.//OTHER_JUSTIFICATION)"/>
			<xsl:when test="./*/*/child::* and not(.//OTHER_JUSTIFICATION)"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.)"/>
					<xsl:choose>
						<xsl:when test=".//OTHER_JUSTIFICATION"> and OTHER_JUSTIFICATION inconsistent</xsl:when>
						<xsl:otherwise> empty</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R241'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R241"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R241"/>
	<xsl:template match="@*|node()" priority="-2" mode="R241">
		<xsl:apply-templates select="@*|*" mode="R241"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15']//*[matches(local-name(),'AWARD_WITHOUT_PRIOR_PUBLICATION')]" mode="R242">
		<xsl:choose>
			<xsl:when test=".//OTHER_JUSTIFICATION/not(preceding-sibling::*)"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(.)"/>
					<xsl:choose>
						<xsl:when test=".//OTHER_JUSTIFICATION/preceding-sibling::*[1]"> and <xsl:value-of select="local-name(.//OTHER_JUSTIFICATION/preceding-sibling::*[1])"/> inconsistent</xsl:when>
						<xsl:otherwise> and OTHER_JUSTIFICATION missing</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R242'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R242"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R242"/>
	<xsl:template match="@*|node()" priority="-2" mode="R242">
		<xsl:apply-templates select="@*|*" mode="R242"/>
	</xsl:template>
	<!-- Pattern  -->
	<xsl:template match="*[@FORM='15'][.//CONTRACT_RESEARCH_DIRECTIVE|.//NO_CONTRACT_RESEARCH_DIRECTIVE]" mode="R243">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')] and .//@NOTICE='CONTRACTING_DEFENCE')"/>
			<xsl:when test=".//TYPE_CONTRACT/@*!='WORKS'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//CONTRACT_RESEARCH_DIRECTIVE|.//NO_CONTRACT_RESEARCH_DIRECTIVE)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R243'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R243"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R243"/>
	<xsl:template match="@*|node()" priority="-2" mode="R243">
		<xsl:apply-templates select="@*|*" mode="R243"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3'][.//MANUFACTURED_BY_DIRECTIVE|.//NO_MANUFACTURED_BY_DIRECTIVE]" mode="R244">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')] )"/>
			<xsl:when test=".//TYPE_CONTRACT='SUPPLIES'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//MANUFACTURED_BY_DIRECTIVE|.//NO_MANUFACTURED_BY_DIRECTIVE)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R244'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R244"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R244"/>
	<xsl:template match="@*|node()" priority="-2" mode="R244">
		<xsl:apply-templates select="@*|*" mode="R244"/>
	</xsl:template>
	<!-- Pattern  -->
	<xsl:template match="*[@FORM='15'][.//MANUFACTURED_BY_DIRECTIVE|.//NO_MANUFACTURED_BY_DIRECTIVE]" mode="R245">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')] and .//@NOTICE='CONTRACTING_DEFENCE')"/>
			<xsl:when test=".//@CTYPE!='WORKS'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//MANUFACTURED_BY_DIRECTIVE|.//NO_MANUFACTURED_BY_DIRECTIVE)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R245'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R245"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R245"/>
	<xsl:template match="@*|node()" priority="-2" mode="R245">
		<xsl:apply-templates select="@*|*" mode="R245"/>
	</xsl:template>
	<!-- Pattern  -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15'][.//WORKS_REPETITION_EXISTING_WORKS|.//NO_WORKS_REPETITION_EXISTING_WORKS]" mode="R246">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')])"/>
			<xsl:when test=".//TYPE_CONTRACT/@*!='SUPPLIES'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//WORKS_REPETITION_EXISTING_WORKS|.//NO_WORKS_REPETITION_EXISTING_WORKS)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R246'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R246"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R246"/>
	<xsl:template match="@*|node()" priority="-2" mode="R246">
		<xsl:apply-templates select="@*|*" mode="R246"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='6'][.//SERVICE_CONTRACT_AWARDED_SUCCESSFUL_CANDIDATE|.//SERVICE_CONTRACT_AWARDED_SUCCESSFUL_CANDIDATE]" mode="R247">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')])"/>
			<xsl:when test=".//TYPE_CONTRACT/@*='SERVICES'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//SERVICE_CONTRACT_AWARDED_SUCCESSFUL_CANDIDATE|.//NO_SERVICE_CONTRACT_AWARDED_SUCCESSFUL_CANDIDATE)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R247'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R247"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R247"/>
	<xsl:template match="@*|node()" priority="-2" mode="R247">
		<xsl:apply-templates select="@*|*" mode="R247"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15'][.//SUPPLIES_QUOTED_PURCHASED_COMMODITY_MARKET|.//NO_SUPPLIES_QUOTED_PURCHASED_COMMODITY_MARKET]" mode="R248">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')])"/>
			<xsl:when test=".//TYPE_CONTRACT/@*='SUPPLIES'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and <xsl:value-of select="local-name(.//SUPPLIES_QUOTED_PURCHASED_COMMODITY_MARKET|.//NO_SUPPLIES_QUOTED_PURCHASED_COMMODITY_MARKET)"/> inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R248'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R248"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R248"/>
	<xsl:template match="@*|node()" priority="-2" mode="R248">
		<xsl:apply-templates select="@*|*" mode="R248"/>
	</xsl:template>
	<!-- Pattern -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15'][.//PURCHASE_SUPPLIES_ADVANTAGEOUS_TERMS/*]" mode="R249">
		<xsl:choose>
			<xsl:when test="not(.//*[matches(local-name(),'PT_NEGOTIATED_WITHOUT_COMPETITION')])"/>
			<xsl:when test=".//TYPE_CONTRACT/@*='SUPPLIES'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and PURCHASE_SUPPLIES_ADVANTAGEOUS_TERMS/* inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R249'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R249"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R249"/>
	<xsl:template match="@*|node()" priority="-2" mode="R249">
		<xsl:apply-templates select="@*|*" mode="R249"/>
	</xsl:template>
</xsl:stylesheet>
