<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : forms_validation
#  Version : R2.0.8.S05                                        
#  Intermediate release number : 22/10/2020                               
#  Last update : 06/07/2020                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/ted/R2.0.8/reception">
	<xsl:output method="xml" omit-xml-declaration="no" standalone="yes" indent="yes"/>
	<!--XML file name-->
	<xsl:param name="file">filename</xsl:param>
	<!--choice of message weight: PROD_WEGHT or QUAL_WEIGHT-->
	<xsl:param name="weight">PROD_WEIGHT</xsl:param>
	<xsl:include href="./build_message.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/">
		<VALIDATION_REPORT>
			<xsl:choose>
				<xsl:when test="not(TED_ESENDERS[.//@VERSION='R2.0.8.S05'])">
					<MESSAGE>Unknown file</MESSAGE>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</VALIDATION_REPORT>
	</xsl:template>
	<xsl:template match="TED_ESENDERS/SENDER">
		<IDENTIFICATION>
			<xsl:apply-templates/>
			<xsl:element name="FILE">
				<xsl:value-of select="$file"/>
			</xsl:element>
		</IDENTIFICATION>
	</xsl:template>
	<xsl:template match="ESENDER_LOGIN|CUSTOMER_LOGIN|NO_DOC_EXT">
		<xsl:choose>
			<xsl:when test="not(ancestor::SENDER)"/>
			<xsl:otherwise>
				<xsl:element name="{local-name()}">
					<xsl:value-of select="current()"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--to control only the first form in the case of bilinguale-->
	<xsl:template match="*[@CATEGORY='ORIGINAL'][position()=1]">
		<LOGS>
			<xsl:apply-templates select="." mode="R980"/>
			<xsl:apply-templates select="." mode="R979"/>
			<!--<xsl:apply-templates select="." mode="R100"/>-->
			<!--<xsl:apply-templates select="." mode="R101"/>-->
			<!--<xsl:apply-templates select="//USER" mode="R102"/>-->
			<xsl:apply-templates select="//USER" mode="R103"/>
			<xsl:apply-templates select="." mode="R103"/>
			<xsl:apply-templates select="//USER" mode="R105"/>
			<xsl:apply-templates select="." mode="R105"/>
			<xsl:apply-templates select="." mode="R107"/>
			<xsl:apply-templates select="/" mode="R108"/>
			<xsl:apply-templates select="." mode="R109"/>
			<xsl:apply-templates select="." mode="R110"/>
			<xsl:apply-templates select="/" mode="R111"/>
			<xsl:apply-templates select="/" mode="R112"/>
			<!--<xsl:apply-templates select="." mode="R114"/>-->
			<!--<xsl:apply-templates select="." mode="R115"/>-->
			<!--<xsl:apply-templates select="." mode="R116"/>-->
			<xsl:apply-templates select="." mode="R158"/>
			<xsl:apply-templates select="." mode="R251"/>
			<!--section I-->
			<xsl:apply-templates select="." mode="R121"/>
			<xsl:apply-templates select="." mode="R122"/>
			<xsl:apply-templates select="." mode="R123"/>
			<xsl:apply-templates select="." mode="R124"/>
			<xsl:apply-templates select="." mode="R125"/>
			<xsl:apply-templates select="." mode="R126"/>
			<xsl:apply-templates select="." mode="R127"/>
			<xsl:apply-templates select="." mode="R128R129R130"/>
			<xsl:apply-templates select="." mode="R131"/>
			<xsl:apply-templates select="." mode="R132"/>
			<xsl:apply-templates select="." mode="R133"/>
			<!--section II-->
			<xsl:apply-templates select="." mode="R134"/>
			<xsl:apply-templates select="." mode="R135"/>
			<xsl:apply-templates select="." mode="R137"/>
			<xsl:apply-templates select="." mode="R138"/>
			<xsl:apply-templates select="." mode="R139"/>
			<xsl:apply-templates select="." mode="R140"/>
			<xsl:apply-templates select="." mode="R142"/>
			<xsl:apply-templates select="." mode="R143"/>
			<xsl:apply-templates select="." mode="R144"/>
			<xsl:apply-templates select="." mode="R145"/>
			<xsl:apply-templates select="." mode="R146"/>
			<xsl:apply-templates select="." mode="R147"/>
			<xsl:apply-templates select="." mode="R148"/>
			<xsl:apply-templates select="." mode="R149"/>
			<xsl:apply-templates select="." mode="R150"/>
			<xsl:apply-templates select="." mode="R151"/>
			<xsl:apply-templates select="." mode="R152"/>
			<xsl:apply-templates select="." mode="R153"/>
			<xsl:apply-templates select="." mode="R154"/>
			<xsl:apply-templates select="." mode="R155"/>
			<xsl:apply-templates select="." mode="R156"/>
			<xsl:apply-templates select="." mode="R157"/>
			<xsl:apply-templates select="." mode="R159"/>
			<xsl:apply-templates select="." mode="R160"/>
			<xsl:apply-templates select="." mode="R161"/>
			<xsl:apply-templates select="." mode="R162"/>
			<xsl:apply-templates select="." mode="R163"/>
			<xsl:apply-templates select="." mode="R164"/>
			<xsl:apply-templates select="." mode="R165"/>
			<!--<xsl:apply-templates select="." mode="R388"/>-->
			<xsl:apply-templates select="." mode="R390"/>
			<!--section III-->
			<xsl:apply-templates select="." mode="R166"/>
			<xsl:apply-templates select="." mode="R167"/>
			<xsl:apply-templates select="." mode="R168"/>
			<xsl:apply-templates select="." mode="R169"/>
			<xsl:apply-templates select="." mode="R170"/>
			<xsl:apply-templates select="." mode="R171"/>
			<xsl:apply-templates select="." mode="R172"/>
			<xsl:apply-templates select="." mode="R173"/>
			<xsl:apply-templates select="." mode="R174"/>
			<xsl:apply-templates select="." mode="R175"/>
			<xsl:apply-templates select="." mode="R176"/>
			<xsl:apply-templates select="." mode="R177"/>
			<!--section IV-->
			<xsl:apply-templates select="." mode="R178"/>
			<xsl:apply-templates select="." mode="R179"/>
			<xsl:apply-templates select="." mode="R180"/>
			<xsl:apply-templates select="." mode="R181"/>
			<xsl:apply-templates select="." mode="R182"/>
			<xsl:apply-templates select="." mode="R183"/>
			<xsl:apply-templates select="." mode="R184"/>
			<xsl:apply-templates select="." mode="R185"/>
			<xsl:apply-templates select="." mode="R186"/>
			<xsl:apply-templates select="." mode="R187"/>
			<xsl:apply-templates select="." mode="R188"/>
			<xsl:apply-templates select="." mode="R189"/>
			<xsl:apply-templates select="." mode="R190"/>
			<xsl:apply-templates select="." mode="R254"/>
			<xsl:apply-templates select="." mode="R191"/>
			<xsl:apply-templates select="." mode="R193"/>
			<xsl:apply-templates select="." mode="R194"/>
			<xsl:apply-templates select="." mode="R196"/>
			<xsl:apply-templates select="." mode="R197"/>
			<xsl:apply-templates select="." mode="R255"/>
			<xsl:apply-templates select="." mode="R198"/>
			<xsl:apply-templates select="." mode="R199"/>
			<xsl:apply-templates select="." mode="R200"/>
			<xsl:apply-templates select="." mode="R256"/>
			<xsl:apply-templates select="." mode="R202"/>
			<xsl:apply-templates select="." mode="R203"/>
			<xsl:apply-templates select="." mode="R204"/>
			<xsl:apply-templates select="." mode="R205"/>
			<xsl:apply-templates select="." mode="R206"/>
			<xsl:apply-templates select="." mode="R207"/>
			<xsl:apply-templates select="." mode="R208"/>
			<xsl:apply-templates select="." mode="R209"/>
			<xsl:apply-templates select="." mode="R210"/>
			<xsl:apply-templates select="." mode="R211R212"/>
			<xsl:apply-templates select="." mode="R211"/>
			<xsl:apply-templates select="." mode="R212"/>
			<xsl:apply-templates select="." mode="R213"/>
			<xsl:apply-templates select="." mode="R214"/>
			<xsl:apply-templates select="." mode="R557"/>
			<xsl:apply-templates select="." mode="R558"/>
			<!--section V-->
			<xsl:apply-templates select="." mode="R215"/>
			<xsl:apply-templates select="." mode="R216"/>
			<xsl:apply-templates select="." mode="R217"/>
			<xsl:apply-templates select="." mode="R218"/>
			<xsl:apply-templates select="." mode="R219"/>
			<xsl:apply-templates select="." mode="R220"/>
			<xsl:apply-templates select="." mode="R222"/>
			<xsl:apply-templates select="." mode="R223"/>
			<xsl:apply-templates select="." mode="R224"/>
			<xsl:apply-templates select="." mode="R225"/>
			<xsl:apply-templates select="." mode="R250"/>
			<xsl:apply-templates select="." mode="R226"/>
			<xsl:apply-templates select="." mode="R227"/>
			<xsl:apply-templates select="." mode="R228"/>
			<xsl:apply-templates select="." mode="R229"/>
			<xsl:apply-templates select="." mode="R619"/>
			<xsl:apply-templates select="." mode="R230"/>
			<!--section VI-->
			<!--<xsl:apply-templates select="." mode="R231"/>-->
			<!--<xsl:apply-templates select="." mode="R232R233"/>-->
			<xsl:apply-templates select="." mode="R234"/>
			<xsl:apply-templates select="." mode="R709"/>
			<!--annex B-->
			<xsl:apply-templates select="." mode="R237"/>
			<xsl:apply-templates select="." mode="R239"/>
			<!--annex D-->
			<xsl:apply-templates select="." mode="R240"/>
			<xsl:apply-templates select="." mode="R241"/>
			<xsl:apply-templates select="." mode="R242"/>
			<xsl:apply-templates select="." mode="R243"/>
			<xsl:apply-templates select="." mode="R244"/>
			<xsl:apply-templates select="." mode="R245"/>
			<xsl:apply-templates select="." mode="R246"/>
			<xsl:apply-templates select="." mode="R247"/>
			<xsl:apply-templates select="." mode="R248"/>
			<xsl:apply-templates select="." mode="R249"/>
		</LOGS>
	</xsl:template>
	<xsl:template match="text()" priority="-1"/>
	<xsl:template match="@*|node()" priority="-2">
		<xsl:apply-templates select="@*|*"/>
	</xsl:template>
	<xsl:include href="./section0.xsl"/>
	<xsl:include href="./section1.xsl"/>
	<xsl:include href="./section2.xsl"/>
	<xsl:include href="./section3.xsl"/>
	<xsl:include href="./section4.xsl"/>
	<xsl:include href="./section5.xsl"/>
	<xsl:include href="./section6.xsl"/>
	<xsl:include href="./annexB.xsl"/>
	<xsl:include href="./annexD.xsl"/>
</xsl:stylesheet>
